<p align="center"><img src="https://raw.githubusercontent.com/kedacore/keda/main/images/keda-logo-transparent.png" width="300"/></p>
<p style="font-size: 25px" align="center"><b>Kubernetes-based Event Driven Autoscaling</b></p>

KEDA allows for fine grained autoscaling (including to/from zero) for event driven Kubernetes workloads.  KEDA serves as a Kubernetes Metrics Server and allows users to define autoscaling rules using a dedicated Kubernetes custom resource definition.

KEDA can run on both the cloud and the edge, integrates natively with Kubernetes components such as the Horizontal Pod Autoscaler, and has no external dependencies.

---
<p align="center">
We are a Cloud Native Computing Foundation (CNCF) graduated project.

<img src="https://raw.githubusercontent.com/kedacore/keda/main/images/logo-cncf.svg" height="75px">
</p>

---

## TL;DR

```console
helm repo add kedacore https://kedacore.github.io/charts
helm repo update

kubectl create namespace keda
helm install keda kedacore/keda --namespace keda --version 2.13.0
```

## Introduction

This chart bootstraps KEDA infrastructure on a Kubernetes cluster using the Helm package manager.

As part of that, it will install all the required Custom Resource Definitions (CRD).

## Installing the Chart

To install the chart with the release name `keda`:

```console
$ kubectl create namespace keda
$ helm install keda kedacore/keda --namespace keda --version 2.13.0
```

## Uninstalling the Chart

To uninstall/delete the `keda` Helm chart:

```console
helm uninstall keda
```

The command removes all the Kubernetes components associated with the chart and deletes the release.

## Configuration

The following table lists the configurable parameters of the KEDA chart and
their default values.

### General parameters

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `additionalAnnotations` | object | `{}` | Custom annotations to add into metadata |
| `additionalLabels` | object | `{}` | Custom labels to add into metadata |
| `affinity` | object | `{}` | [Affinity] for pod scheduling for both KEDA operator and Metrics API Server |
| `asciiArt` | bool | `true` | Capability to turn on/off ASCII art in Helm installation notes |
| `certificates.autoGenerated` | bool | `true` | Enables the self generation for KEDA TLS certificates inside KEDA operator |
| `certificates.certManager.caSecretName` | string | `"kedaorg-ca"` | Secret name where the CA is stored (generatedby cert-manager or user given) |
| `certificates.certManager.duration` | string | `"8760h0m0s"` | Certificate duration |
| `certificates.certManager.enabled` | bool | `false` | Enables Cert-manager for certificate management |
| `certificates.certManager.generateCA` | bool | `true` | Generates a self-signed CA with Cert-manager. If generateCA is false, the secret with the CA has to be annotated with `cert-manager.io/allow-direct-injection: "true"` |
| `certificates.certManager.issuer` | object | `{"generate":true,"group":"cert-manager.io","kind":"ClusterIssuer","name":"foo-org-ca"}` | Reference to custom Issuer. If issuer.generate is false, then issuer.group, issuer.kind and issuer.name are required |
| `certificates.certManager.issuer.generate` | bool | `true` | Generates an Issuer resource with Cert-manager |
| `certificates.certManager.issuer.group` | string | `"cert-manager.io"` | Custom Issuer group. Required when generate: false |
| `certificates.certManager.issuer.kind` | string | `"ClusterIssuer"` | Custom Issuer kind. Required when generate: false |
| `certificates.certManager.issuer.name` | string | `"foo-org-ca"` | Custom Issuer name. Required when generate: false |
| `certificates.certManager.renewBefore` | string | `"5840h0m0s"` | Certificate renewal time before expiration |
| `certificates.certManager.secretTemplate` | object | `{}` | Add labels/annotations to secrets created by Certificate resources [docs](https://cert-manager.io/docs/usage/certificate/#creating-certificate-resources) |
| `certificates.mountPath` | string | `"/certs"` | Path where KEDA TLS certificates are mounted |
| `certificates.secretName` | string | `"kedaorg-certs"` | Secret name to be mounted with KEDA TLS certificates |
| `clusterDomain` | string | `"cluster.local"` | Kubernetes cluster domain |
| `clusterName` | string | `"kubernetes-default"` | Kubernetes cluster name. Used in features such as emitting CloudEvents |
| `crds.additionalAnnotations` | object | `{}` | Custom annotations specifically for CRDs |
| `crds.install` | bool | `true` | Defines whether the KEDA CRDs have to be installed or not. |
| `env` | list | `[]` | Additional environment variables that will be passed onto all KEDA components |
| `extraObjects` | list | `[]` | Array of extra K8s manifests to deploy |
| `global.image.registry` | string | `nil` | Global image registry of KEDA components |
| `grpcTLSCertsSecret` | string | `""` | Set this if you are using an external scaler and want to communicate over TLS (recommended). This variable holds the name of the secret that will be mounted to the /grpccerts path on the Pod |
| `hashiCorpVaultTLS` | string | `""` | Set this if you are using HashiCorp Vault and want to communicate over TLS (recommended). This variable holds the name of the secret that will be mounted to the /vault path on the Pod |
| `http.keepAlive.enabled` | bool | `true` | Enable HTTP connection keep alive |
| `http.minTlsVersion` | string | `"TLS12"` | The minimum TLS version to use for all scalers that use raw HTTP clients (some scalers use SDKs to access target services. These have built-in HTTP clients, and this value does not necessarily apply to them) |
| `http.timeout` | int | `3000` | The default HTTP timeout to use for all scalers that use raw HTTP clients (some scalers use SDKs to access target services. These have built-in HTTP clients, and the timeout does not necessarily apply to them) |
| `image.pullPolicy` | string | `"Always"` | Image pullPolicy for all KEDA components |
| `imagePullSecrets` | list | `[]` | Name of secret to use to pull images to use to pull Docker images |
| `networkPolicy.cilium` | object | `{"operator":{"extraEgressRules":[]}}` | Allow use of extra egress rules for cilium network policies |
| `networkPolicy.enabled` | bool | `false` | Enable network policies |
| `networkPolicy.flavor` | string | `"cilium"` | Flavor of the network policies (cilium) |
| `nodeSelector` | object | `{}` | Node selector for pod scheduling ([docs](https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/)) |
| `podIdentity.activeDirectory.identity` | string | `""` | Identity in Azure Active Directory to use for Azure pod identity |
| `podIdentity.aws.irsa.audience` | string | `"sts.amazonaws.com"` | Sets the token audience for IRSA. This will be set as an annotation on the KEDA service account. |
| `podIdentity.aws.irsa.enabled` | bool | `false` | Specifies whether [AWS IAM Roles for Service Accounts (IRSA)](https://docs.aws.amazon.com/eks/latest/userguide/iam-roles-for-service-accounts.html) is to be enabled or not. |
| `podIdentity.aws.irsa.roleArn` | string | `""` | Set to the value of the ARN of an IAM role with a web identity provider. This will be set as an annotation on the KEDA service account. |
| `podIdentity.aws.irsa.stsRegionalEndpoints` | string | `"true"` | Sets the use of an STS regional endpoint instead of global. Recommended to use regional endpoint in almost all cases. This will be set as an annotation on the KEDA service account. |
| `podIdentity.aws.irsa.tokenExpiration` | int | `86400` | Set to the value of the service account token expiration duration. This will be set as an annotation on the KEDA service account. |
| `podIdentity.azureWorkload.clientId` | string | `""` | Id of Azure Active Directory Client to use for authentication with Azure Workload Identity. ([docs](https://keda.sh/docs/concepts/authentication/#azure-workload-identity)) |
| `podIdentity.azureWorkload.enabled` | bool | `false` | Set to true to enable Azure Workload Identity usage. See https://keda.sh/docs/concepts/authentication/#azure-workload-identity This will be set as a label on the KEDA service account. |
| `podIdentity.azureWorkload.tenantId` | string | `""` | Id Azure Active Directory Tenant to use for authentication with for Azure Workload Identity. ([docs](https://keda.sh/docs/concepts/authentication/#azure-workload-identity)) |
| `podIdentity.azureWorkload.tokenExpiration` | int | `3600` | Duration in seconds to automatically expire tokens for the service account. ([docs](https://keda.sh/docs/concepts/authentication/#azure-workload-identity)) |
| `podIdentity.gcp.enabled` | bool | `false` | Set to true to enable GCP Workload Identity. See https://keda.sh/docs/2.10/authentication-providers/gcp-workload-identity/ This will be set as a annotation on the KEDA service account. |
| `podIdentity.gcp.gcpIAMServiceAccount` | string | `""` | GCP IAM Service Account Email which you would like to use for workload identity. |
| `podSecurityContext` | object | [See below](#KEDA-is-secure-by-default) | [Pod security context] for all pods |
| `priorityClassName` | string | `""` | priorityClassName for all KEDA components |
| `rbac.aggregateToDefaultRoles` | bool | `false` | Specifies whether RBAC for CRDs should be [aggregated](https://kubernetes.io/docs/reference/access-authn-authz/rbac/#aggregated-clusterroles) to default roles (view, edit, admin) |
| `rbac.create` | bool | `true` | Specifies whether RBAC should be used |
| `securityContext` | object | [See below](#KEDA-is-secure-by-default) | [Security context] for all containers |
| `serviceAccount.annotations` | object | `{}` | Annotations to add to the service account |
| `serviceAccount.automountServiceAccountToken` | bool | `true` | Specifies whether a service account should automount API-Credentials |
| `serviceAccount.create` | bool | `true` | Specifies whether a service account should be created |
| `serviceAccount.name` | string | `"keda-operator"` | The name of the service account to use. If not set and create is true, a name is generated using the fullname template |
| `tolerations` | list | `[]` | Tolerations for pod scheduling ([docs](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/)) |
| `watchNamespace` | string | `""` | Defines Kubernetes namespaces to watch to scale their workloads. Default watches all namespaces |

### Operator

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `extraArgs.keda` | object | `{}` | Additional KEDA Operator container arguments |
| `image.keda.registry` | string | `nil` | Image registry of KEDA operator |
| `image.keda.repository` | string | `"ghcr.io/kedacore/keda"` | Image name of KEDA operator |
| `image.keda.tag` | string | `""` | Image tag of KEDA operator. Optional, given app version of Helm chart is used by default |
| `logging.operator.format` | string | `"console"` | Logging format for KEDA Operator. allowed values: `json` or `console` |
| `logging.operator.level` | string | `"info"` | Logging level for KEDA Operator. allowed values: `debug`, `info`, `error`, or an integer value greater than 0, specified as string |
| `logging.operator.timeEncoding` | string | `"rfc3339"` | Logging time encoding for KEDA Operator. allowed values are `epoch`, `millis`, `nano`, `iso8601`, `rfc3339` or `rfc3339nano` |
| `operator.affinity` | object | `{}` | [Affinity] for pod scheduling for KEDA operator. Takes precedence over the `affinity` field |
| `operator.disableCompression` | bool | `true` | Disable response compression for k8s restAPI in client-go. Disabling compression simply means that turns off the process of making data smaller for K8s restAPI in client-go for faster transmission. |
| `operator.livenessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":25,"periodSeconds":10,"successThreshold":1,"timeoutSeconds":1}` | Liveness probes for operator ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/)) |
| `operator.name` | string | `"keda-operator"` | Name of the KEDA operator |
| `operator.readinessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":20,"periodSeconds":3,"successThreshold":1,"timeoutSeconds":1}` | Readiness probes for operator ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/#define-readiness-probes)) |
| `operator.replicaCount` | int | `1` | Capability to configure the number of replicas for KEDA operator. While you can run more replicas of our operator, only one operator instance will be the leader and serving traffic. You can run multiple replicas, but they will not improve the performance of KEDA, it could only reduce downtime during a failover. Learn more in [our documentation](https://keda.sh/docs/latest/operate/cluster/#high-availability). |
| `operator.revisionHistoryLimit` | int | `10` | ReplicaSets for this Deployment you want to retain (Default: 10) |
| `permissions.operator.restrict.secret` | bool | `false` | Restrict Secret Access for KEDA operator |
| `podAnnotations.keda` | object | `{}` | Pod annotations for KEDA operator |
| `podDisruptionBudget.operator` | object | `{}` | Capability to configure [Pod Disruption Budget] |
| `podLabels.keda` | object | `{}` | Pod labels for KEDA operator |
| `podSecurityContext.operator` | object | [See below](#KEDA-is-secure-by-default) | [Pod security context] of the KEDA operator pod |
| `resources.operator` | object | `{"limits":{"cpu":1,"memory":"1000Mi"},"requests":{"cpu":"100m","memory":"100Mi"}}` | Manage [resource request & limits] of KEDA operator pod |
| `securityContext.operator` | object | [See below](#KEDA-is-secure-by-default) | [Security context] of the operator container |
| `topologySpreadConstraints.operator` | list | `[]` | [Pod Topology Constraints] of KEDA operator pod |
| `upgradeStrategy.operator` | object | `{}` | Capability to configure [Deployment upgrade strategy] for operator |
| `volumes.keda.extraVolumeMounts` | list | `[]` | Extra volume mounts for KEDA deployment |
| `volumes.keda.extraVolumes` | list | `[]` | Extra volumes for KEDA deployment |

### Metrics server

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `extraArgs.metricsAdapter` | object | `{}` | Additional Metrics Adapter container arguments |
| `image.metricsApiServer.registry` | string | `nil` | Image registry of KEDA Metrics API Server |
| `image.metricsApiServer.repository` | string | `"ghcr.io/kedacore/keda-metrics-apiserver"` | Image name of KEDA Metrics API Server |
| `image.metricsApiServer.tag` | string | `""` | Image tag of KEDA Metrics API Server. Optional, given app version of Helm chart is used by default |
| `logging.metricServer.level` | int | `0` | Logging level for Metrics Server. allowed values: `0` for info, `4` for debug, or an integer value greater than 0, specified as string |
| `logging.metricServer.stderrthreshold` | string | `"ERROR"` | Logging stderrthreshold for Metrics Server allowed values: 'DEBUG','INFO','WARN','ERROR','ALERT','EMERG' |
| `metricsServer.affinity` | object | `{}` | [Affinity] for pod scheduling for Metrics API Server. Takes precedence over the `affinity` field |
| `metricsServer.disableCompression` | bool | `true` | Disable response compression for k8s restAPI in client-go. Disabling compression simply means that turns off the process of making data smaller for K8s restAPI in client-go for faster transmission. |
| `metricsServer.dnsPolicy` | string | `"ClusterFirst"` | Defined the DNS policy for the metric server |
| `metricsServer.livenessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":5,"periodSeconds":10,"successThreshold":1,"timeoutSeconds":1}` | Liveness probes for Metrics API Server ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/)) |
| `metricsServer.readinessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":5,"periodSeconds":3,"successThreshold":1,"timeoutSeconds":1}` | Readiness probes for Metrics API Server ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/#define-readiness-probes)) |
| `metricsServer.replicaCount` | int | `1` | Capability to configure the number of replicas for KEDA metric server. While you can run more replicas of our metric server, only one instance will used and serve traffic. You can run multiple replicas, but they will not improve the performance of KEDA, it could only reduce downtime during a failover. Learn more in [our documentation](https://keda.sh/docs/latest/operate/cluster/#high-availability). |
| `metricsServer.revisionHistoryLimit` | int | `10` | ReplicaSets for this Deployment you want to retain (Default: 10) |
| `metricsServer.useHostNetwork` | bool | `false` | Enable metric server to use host network |
| `permissions.metricServer.restrict.secret` | bool | `false` | Restrict Secret Access for Metrics Server |
| `podAnnotations.metricsAdapter` | object | `{}` | Pod annotations for KEDA Metrics Adapter |
| `podDisruptionBudget.metricServer` | object | `{}` | Capability to configure [Pod Disruption Budget] |
| `podLabels.metricsAdapter` | object | `{}` | Pod labels for KEDA Metrics Adapter |
| `podSecurityContext.metricServer` | object | [See below](#KEDA-is-secure-by-default) | [Pod security context] of the KEDA metrics apiserver pod |
| `resources.metricServer` | object | `{"limits":{"cpu":1,"memory":"1000Mi"},"requests":{"cpu":"100m","memory":"100Mi"}}` | Manage [resource request & limits] of KEDA metrics apiserver pod |
| `securityContext.metricServer` | object | [See below](#KEDA-is-secure-by-default) | [Security context] of the metricServer container |
| `service.annotations` | object | `{}` | Annotations to add the KEDA Metric Server service |
| `service.portHttps` | int | `443` | HTTPS port for KEDA Metric Server service |
| `service.portHttpsTarget` | int | `6443` | HTTPS port for KEDA Metric Server container |
| `service.type` | string | `"ClusterIP"` | KEDA Metric Server service type |
| `topologySpreadConstraints.metricsServer` | list | `[]` | [Pod Topology Constraints] of KEDA metrics apiserver pod |
| `upgradeStrategy.metricsApiServer` | object | `{}` | Capability to configure [Deployment upgrade strategy] for Metrics Api Server |
| `volumes.metricsApiServer.extraVolumeMounts` | list | `[]` | Extra volume mounts for metric server deployment |
| `volumes.metricsApiServer.extraVolumes` | list | `[]` | Extra volumes for metric server deployment |

### Operations

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `opentelemetry.collector.uri` | string | `""` | Uri of OpenTelemetry Collector to push telemetry to |
| `opentelemetry.operator.enabled` | bool | `false` | Enable pushing metrics to an OpenTelemetry Collector for operator |
| `prometheus.metricServer.enabled` | bool | `false` | Enable metric server Prometheus metrics expose |
| `prometheus.metricServer.podMonitor.additionalLabels` | object | `{}` | Additional labels to add for metric server using podMonitor crd (prometheus operator) |
| `prometheus.metricServer.podMonitor.enabled` | bool | `false` | Enables PodMonitor creation for the Prometheus Operator |
| `prometheus.metricServer.podMonitor.interval` | string | `""` | Scraping interval for metric server using podMonitor crd (prometheus operator) |
| `prometheus.metricServer.podMonitor.metricRelabelings` | list | `[]` | List of expressions that define custom  metric relabeling rules for metric server PodMonitor crd after scrape has happened (prometheus operator). [RelabelConfig Spec] |
| `prometheus.metricServer.podMonitor.namespace` | string | `""` | Scraping namespace for metric server using podMonitor crd (prometheus operator) |
| `prometheus.metricServer.podMonitor.relabelings` | list | `[]` | List of expressions that define custom relabeling rules for metric server podMonitor crd (prometheus operator) |
| `prometheus.metricServer.podMonitor.scrapeTimeout` | string | `""` | Scraping timeout for metric server using podMonitor crd (prometheus operator) |
| `prometheus.metricServer.port` | int | `8080` | HTTP port used for exposing metrics server prometheus metrics |
| `prometheus.metricServer.portName` | string | `"metrics"` | HTTP port name for exposing metrics server prometheus metrics |
| `prometheus.metricServer.serviceMonitor.additionalLabels` | object | `{}` | Additional labels to add for metric server using ServiceMonitor crd (prometheus operator) |
| `prometheus.metricServer.serviceMonitor.enabled` | bool | `false` | Enables ServiceMonitor creation for the Prometheus Operator |
| `prometheus.metricServer.serviceMonitor.interval` | string | `""` | Interval at which metrics should be scraped If not specified Prometheus’ global scrape interval is used. |
| `prometheus.metricServer.serviceMonitor.jobLabel` | string | `""` | JobLabel selects the label from the associated Kubernetes service which will be used as the job label for all metrics. [ServiceMonitor Spec] |
| `prometheus.metricServer.serviceMonitor.metricRelabelings` | list | `[]` | List of expressions that define custom  metric relabeling rules for metric server ServiceMonitor crd after scrape has happened (prometheus operator). [RelabelConfig Spec] |
| `prometheus.metricServer.serviceMonitor.podTargetLabels` | list | `[]` | PodTargetLabels transfers labels on the Kubernetes `Pod` onto the created metrics |
| `prometheus.metricServer.serviceMonitor.port` | string | `"metrics"` | Name of the service port this endpoint refers to. Mutually exclusive with targetPort |
| `prometheus.metricServer.serviceMonitor.relabelings` | list | `[]` | List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.metricServer.serviceMonitor.relabellings` | list | `[]` | DEPRECATED. List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.metricServer.serviceMonitor.scheme` | string | `"http"` | HTTP scheme used for scraping. Defaults to `http` |
| `prometheus.metricServer.serviceMonitor.scrapeTimeout` | string | `""` | Timeout after which the scrape is ended If not specified, the Prometheus global scrape timeout is used unless it is less than Interval in which the latter is used |
| `prometheus.metricServer.serviceMonitor.targetLabels` | list | `[]` | TargetLabels transfers labels from the Kubernetes `Service` onto the created metrics |
| `prometheus.metricServer.serviceMonitor.targetPort` | string | `""` | Name or number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port |
| `prometheus.metricServer.serviceMonitor.tlsConfig` | object | `{}` | TLS configuration for scraping metrics |
| `prometheus.operator.enabled` | bool | `false` | Enable KEDA Operator prometheus metrics expose |
| `prometheus.operator.podMonitor.additionalLabels` | object | `{}` | Additional labels to add for KEDA Operator using podMonitor crd (prometheus operator) |
| `prometheus.operator.podMonitor.enabled` | bool | `false` | Enables PodMonitor creation for the Prometheus Operator |
| `prometheus.operator.podMonitor.interval` | string | `""` | Scraping interval for KEDA Operator using podMonitor crd (prometheus operator) |
| `prometheus.operator.podMonitor.metricRelabelings` | list | `[]` | List of expressions that define custom  metric relabeling rules for metric server PodMonitor crd after scrape has happened (prometheus operator). [RelabelConfig Spec] |
| `prometheus.operator.podMonitor.namespace` | string | `""` | Scraping namespace for KEDA Operator using podMonitor crd (prometheus operator) |
| `prometheus.operator.podMonitor.relabelings` | list | `[]` | List of expressions that define custom relabeling rules for KEDA Operator podMonitor crd (prometheus operator) |
| `prometheus.operator.podMonitor.scrapeTimeout` | string | `""` | Scraping timeout for KEDA Operator using podMonitor crd (prometheus operator) |
| `prometheus.operator.port` | int | `8080` | Port used for exposing KEDA Operator prometheus metrics |
| `prometheus.operator.prometheusRules.additionalLabels` | object | `{}` | Additional labels to add for KEDA Operator using prometheusRules crd (prometheus operator) |
| `prometheus.operator.prometheusRules.alerts` | list | `[]` | Additional alerts to add for KEDA Operator using prometheusRules crd (prometheus operator) |
| `prometheus.operator.prometheusRules.enabled` | bool | `false` | Enables PrometheusRules creation for the Prometheus Operator |
| `prometheus.operator.prometheusRules.namespace` | string | `""` | Scraping namespace for KEDA Operator using prometheusRules crd (prometheus operator) |
| `prometheus.operator.serviceMonitor.additionalLabels` | object | `{}` | Additional labels to add for metric server using ServiceMonitor crd (prometheus operator) |
| `prometheus.operator.serviceMonitor.enabled` | bool | `false` | Enables ServiceMonitor creation for the Prometheus Operator |
| `prometheus.operator.serviceMonitor.interval` | string | `""` | Interval at which metrics should be scraped If not specified Prometheus’ global scrape interval is used. |
| `prometheus.operator.serviceMonitor.jobLabel` | string | `""` | JobLabel selects the label from the associated Kubernetes service which will be used as the job label for all metrics. [ServiceMonitor Spec] |
| `prometheus.operator.serviceMonitor.metricRelabelings` | list | `[]` | List of expressions that define custom  metric relabeling rules for metric server ServiceMonitor crd after scrape has happened (prometheus operator). [RelabelConfig Spec] |
| `prometheus.operator.serviceMonitor.podTargetLabels` | list | `[]` | PodTargetLabels transfers labels on the Kubernetes `Pod` onto the created metrics |
| `prometheus.operator.serviceMonitor.port` | string | `"metrics"` | Name of the service port this endpoint refers to. Mutually exclusive with targetPort |
| `prometheus.operator.serviceMonitor.relabelings` | list | `[]` | List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.operator.serviceMonitor.relabellings` | list | `[]` | DEPRECATED. List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.operator.serviceMonitor.scheme` | string | `"http"` | HTTP scheme used for scraping. Defaults to `http` |
| `prometheus.operator.serviceMonitor.scrapeTimeout` | string | `""` | Timeout after which the scrape is ended If not specified, the Prometheus global scrape timeout is used unless it is less than Interval in which the latter is used |
| `prometheus.operator.serviceMonitor.targetLabels` | list | `[]` | TargetLabels transfers labels from the Kubernetes `Service` onto the created metrics |
| `prometheus.operator.serviceMonitor.targetPort` | string | `""` | Name or number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port |
| `prometheus.operator.serviceMonitor.tlsConfig` | object | `{}` | TLS configuration for scraping metrics |
| `prometheus.webhooks.enabled` | bool | `false` | Enable KEDA admission webhooks prometheus metrics expose |
| `prometheus.webhooks.port` | int | `8080` | Port used for exposing KEDA admission webhooks prometheus metrics |
| `prometheus.webhooks.prometheusRules.additionalLabels` | object | `{}` | Additional labels to add for KEDA admission webhooks using prometheusRules crd (prometheus operator) |
| `prometheus.webhooks.prometheusRules.alerts` | list | `[]` | Additional alerts to add for KEDA admission webhooks using prometheusRules crd (prometheus operator) |
| `prometheus.webhooks.prometheusRules.enabled` | bool | `false` | Enables PrometheusRules creation for the Prometheus Operator |
| `prometheus.webhooks.prometheusRules.namespace` | string | `""` | Scraping namespace for KEDA admission webhooks using prometheusRules crd (prometheus operator) |
| `prometheus.webhooks.serviceMonitor.additionalLabels` | object | `{}` | Additional labels to add for metric server using ServiceMonitor crd (prometheus operator) |
| `prometheus.webhooks.serviceMonitor.enabled` | bool | `false` | Enables ServiceMonitor creation for the Prometheus webhooks |
| `prometheus.webhooks.serviceMonitor.interval` | string | `""` | Interval at which metrics should be scraped If not specified Prometheus’ global scrape interval is used. |
| `prometheus.webhooks.serviceMonitor.jobLabel` | string | `""` | jobLabel selects the label from the associated Kubernetes service which will be used as the job label for all metrics. [ServiceMonitor Spec] |
| `prometheus.webhooks.serviceMonitor.metricRelabelings` | list | `[]` | List of expressions that define custom  metric relabeling rules for metric server ServiceMonitor crd after scrape has happened (prometheus operator). [RelabelConfig Spec] |
| `prometheus.webhooks.serviceMonitor.podTargetLabels` | list | `[]` | PodTargetLabels transfers labels on the Kubernetes `Pod` onto the created metrics |
| `prometheus.webhooks.serviceMonitor.port` | string | `"metrics"` | Name of the service port this endpoint refers to. Mutually exclusive with targetPort |
| `prometheus.webhooks.serviceMonitor.relabelings` | list | `[]` | List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.webhooks.serviceMonitor.relabellings` | list | `[]` | DEPRECATED. List of expressions that define custom relabeling rules for metric server ServiceMonitor crd (prometheus operator). [RelabelConfig Spec] |
| `prometheus.webhooks.serviceMonitor.scheme` | string | `"http"` | HTTP scheme used for scraping. Defaults to `http` |
| `prometheus.webhooks.serviceMonitor.scrapeTimeout` | string | `""` | Timeout after which the scrape is ended If not specified, the Prometheus global scrape timeout is used unless it is less than Interval in which the latter is used |
| `prometheus.webhooks.serviceMonitor.targetLabels` | list | `[]` | TargetLabels transfers labels from the Kubernetes `Service` onto the created metrics |
| `prometheus.webhooks.serviceMonitor.targetPort` | string | `""` | Name or number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port |
| `prometheus.webhooks.serviceMonitor.tlsConfig` | object | `{}` | TLS configuration for scraping metrics |

### Troubleshooting

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `profiling.metricsServer.enabled` | bool | `false` | Enable profiling for KEDA metrics server |
| `profiling.metricsServer.port` | int | `8083` | Expose profiling on a specific port |
| `profiling.operator.enabled` | bool | `false` | Enable profiling for KEDA operator |
| `profiling.operator.port` | int | `8082` | Expose profiling on a specific port |
| `profiling.webhooks.enabled` | bool | `false` | Enable profiling for KEDA admission webhook |
| `profiling.webhooks.port` | int | `8084` | Expose profiling on a specific port |

### Admission Webhooks

| Parameter | Type | Default | Description |
|-----------|------|---------|-------------|
| `image.webhooks.registry` | string | `nil` | Image registry of KEDA admission-webhooks |
| `image.webhooks.repository` | string | `"ghcr.io/kedacore/keda-admission-webhooks"` | Image name of KEDA admission-webhooks |
| `image.webhooks.tag` | string | `""` | Image tag of KEDA admission-webhooks . Optional, given app version of Helm chart is used by default |
| `logging.webhooks.format` | string | `"console"` | Logging format for KEDA Admission webhooks. allowed values: `json` or `console` |
| `logging.webhooks.level` | string | `"info"` | Logging level for KEDA Operator. allowed values: `debug`, `info`, `error`, or an integer value greater than 0, specified as string |
| `logging.webhooks.timeEncoding` | string | `"rfc3339"` | Logging time encoding for KEDA Operator. allowed values are `epoch`, `millis`, `nano`, `iso8601`, `rfc3339` or `rfc3339nano` |
| `podAnnotations.webhooks` | object | `{}` | Pod annotations for KEDA Admission webhooks |
| `podDisruptionBudget.webhooks` | object | `{}` | Capability to configure [Pod Disruption Budget] |
| `podLabels.webhooks` | object | `{}` | Pod labels for KEDA Admission webhooks |
| `podSecurityContext.webhooks` | object | [See below](#KEDA-is-secure-by-default) | [Pod security context] of the KEDA admission webhooks |
| `resources.webhooks` | object | `{"limits":{"cpu":"50m","memory":"100Mi"},"requests":{"cpu":"10m","memory":"10Mi"}}` | Manage [resource request & limits] of KEDA admission webhooks pod |
| `securityContext.webhooks` | object | [See below](#KEDA-is-secure-by-default) | [Security context] of the admission webhooks container |
| `topologySpreadConstraints.webhooks` | list | `[]` | [Pod Topology Constraints] of KEDA admission webhooks pod |
| `upgradeStrategy.webhooks` | object | `{}` | Capability to configure [Deployment upgrade strategy] for Admission webhooks |
| `volumes.webhooks.extraVolumeMounts` | list | `[]` | Extra volume mounts for admission webhooks deployment |
| `volumes.webhooks.extraVolumes` | list | `[]` | Extra volumes for admission webhooks deployment |
| `webhooks.affinity` | object | `{}` | [Affinity] for pod scheduling for KEDA admission webhooks. Takes precedence over the `affinity` field |
| `webhooks.enabled` | bool | `true` | Enable admission webhooks (this feature option will be removed in v2.12) |
| `webhooks.failurePolicy` | string | `"Ignore"` | [Failure policy](https://kubernetes.io/docs/reference/access-authn-authz/extensible-admission-controllers/#failure-policy) to use with KEDA admission webhooks |
| `webhooks.healthProbePort` | int | `8081` | Port number to use for KEDA admission webhooks health probe |
| `webhooks.livenessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":25,"periodSeconds":10,"successThreshold":1,"timeoutSeconds":1}` | Liveness probes for admission webhooks ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/)) |
| `webhooks.name` | string | `"keda-admission-webhooks"` | Name of the KEDA admission webhooks |
| `webhooks.port` | string | `""` | Port number to use for KEDA admission webhooks. Default is 9443. |
| `webhooks.readinessProbe` | object | `{"failureThreshold":3,"initialDelaySeconds":20,"periodSeconds":3,"successThreshold":1,"timeoutSeconds":1}` | Readiness probes for admission webhooks ([docs](https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-startup-probes/#define-readiness-probes)) |
| `webhooks.replicaCount` | int | `1` | Capability to configure the number of replicas for KEDA admission webhooks |
| `webhooks.revisionHistoryLimit` | int | `10` | ReplicaSets for this Deployment you want to retain (Default: 10) |
| `webhooks.useHostNetwork` | bool | `false` | Enable webhook to use host network, this is required on EKS with custom CNI |

Specify each parameter using the `--set key=value[,key=value]` argument to
`helm install`. For example:

```console
$ helm install keda kedacore/keda --namespace keda \
               --set image.keda.tag=<different tag from app version> \
               --set image.metricsApiServer.tag=<different tag from app version> \
               --set image.webhooks.tag=<different tag from app version>
```

Alternatively, a YAML file that specifies the values for the above parameters can
be provided while installing the chart. For example,

```console
helm install keda kedacore/keda --namespace keda -f values.yaml
```

## KEDA is secure by default

Our default configuration strives to be as secure as possible. Because of that, KEDA will run as non-root and be secure-by-default:
```yaml
securityContext:
  operator:
    capabilities:
      drop:
      - ALL
    allowPrivilegeEscalation: false
    readOnlyRootFilesystem: true
    seccompProfile:
      type: RuntimeDefault
  metricServer:
    capabilities:
      drop:
      - ALL
    allowPrivilegeEscalation: false
    ## Metrics server needs to write the self-signed cert. See FAQ for discussion of options.
    # readOnlyRootFilesystem: true
    seccompProfile:
      type: RuntimeDefault
  webhooks:
    capabilities:
      drop:
      - ALL
    allowPrivilegeEscalation: false
    readOnlyRootFilesystem: true
    seccompProfile:
      type: RuntimeDefault

podSecurityContext:
  operator:
    runAsNonRoot: true
  metricServer:
    runAsNonRoot: true
  webhooks:
    runAsNonRoot: true
```

----------------------------------------------
Autogenerated from chart metadata using [helm-docs](https://github.com/norwoodj/helm-docs)

[Affinity]: https://kubernetes.io/docs/tasks/configure-pod-container/assign-pods-nodes-using-node-affinity/
[Deployment upgrade strategy]: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#strategy
[GCP Workload Identity]: https://keda.sh/docs/2.10/authentication-providers/gcp-workload-identity/
[Pod Disruption Budget]: https://kubernetes.io/docs/tasks/run-application/configure-pdb/
[Pod security context]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
[Security context]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/#set-the-security-context-for-a-container
[Pod Topology Constraints]: https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/
[RelabelConfig Spec]: https://github.com/prometheus-operator/prometheus-operator/blob/main/Documentation/api.md#monitoring.coreos.com/v1.RelabelConfig
[resource request & limits]: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
[ServiceMonitor Spec]: https://github.com/prometheus-operator/prometheus-operator/blob/main/Documentation/api.md#monitoring.coreos.com/v1.ServiceMonitor
