#!/bin/bash

# Define the Sisense namespace
source installer/common/functions.sh

function patch_single() {
  # Define the list of PVs and PVCs for "single"
  local pv_list=("dgraph-${config_namespace_name}-volume" "mongodb-${config_namespace_name}-volume" "zookeeper-${config_namespace_name}-volume")
  local pvc_list=("data-dgraph-0" "data-mongodb-0" "data-zookeeper-0")

  # Patch PVs
  for pv in "${pv_list[@]}"; do
    assign_to_helm_release PersistentVolume ${pv} ${config_namespace_name} ${config_namespace_name}
  done

  # Patch PVCs
  for pvc in "${pvc_list[@]}"; do
    assign_to_helm_release PersistentVolumeClaim ${pvc} ${config_namespace_name} ${config_namespace_name}
  done

  # If grafana pvc does not contain selector labels, remove it
  local grafana_pvc_selector=$(kubectl -n ${config_namespace_name} get pvc ${config_namespace_name}-grafana -ojsonpath='{.spec.selector.matchLabels.app}' --ignore-not-found)
  if [[ ${grafana_pvc_selector} != "grafana-${config_namespace_name}" ]]; then
    log_royal_blue "Patching Sisense Grafana"
    if kubectl get deploy -n ${config_namespace_name} ${config_namespace_name}-grafana > /dev/null 2>&1; then
      run_command "kubectl scale deploy -n ${config_namespace_name} ${config_namespace_name}-grafana --replicas=0"
    fi
    run_command "kubectl delete pvc -n ${config_namespace_name} ${config_namespace_name}-grafana --ignore-not-found"
    run_command "kubectl delete pv grafana-${config_namespace_name}-db --ignore-not-found"
  fi
  log_green "Single resources have been updated"
}

function patch_pvc() {
  local pvc="storage"
  assign_to_helm_release PersistentVolumeClaim ${pvc} ${config_namespace_name} ${config_namespace_name}

  log_green "Storage pvc has been updated"
}

function patch_fsx() {
  local pv="${config_namespace_name}-storage-pv"
  local pvc="storage"
  assign_to_helm_release PersistentVolume ${pv} ${config_namespace_name} ${config_namespace_name}
  assign_to_helm_release PersistentVolumeClaim ${pvc} ${config_namespace_name} ${config_namespace_name}

  log_green "FSX resources have been updated"
}

function patch_rook_ceph() {
  local pv="grafana-${config_namespace_name}-db"
  local pvc="storage"
  assign_to_helm_release PersistentVolume ${pv} ${config_namespace_name} ${config_namespace_name}
  assign_to_helm_release PersistentVolumeClaim ${pvc} ${config_namespace_name} ${config_namespace_name}

  # If grafana pvc does not contain selector labels, remove it
  local grafana_pvc_selector=$(kubectl -n sisense get pvc sisense-grafana -ojsonpath='{.spec.selector.matchLabels.app}' --ignore-not-found)
  if [[ ${grafana_pvc_selector} != "grafana-${config_namespace_name}" ]]; then
    log_royal_blue "Patching Sisense Grafana"
    if kubectl get deploy -n ${config_namespace_name} ${config_namespace_name}-grafana > /dev/null 2>&1; then
      run_command "kubectl scale deploy -n ${config_namespace_name} ${config_namespace_name}-grafana --replicas=0"
    fi
    run_command "kubectl delete pvc -n ${config_namespace_name} ${config_namespace_name}-grafana --ignore-not-found"
    run_command "kubectl delete pv grafana-${config_namespace_name}-db --ignore-not-found"
  fi

  log_green "Rook-Ceph resources have been updated"
}
