#!/usr/bin/env bash

source installer/05_post_infra/functions.sh

if not_uninstall; then
  if ! check_condition ${config_within_provisioner}; then
    get_binaries
    get_helm_mapkubeapis
    kubectl_auto_completion
    if need_infra_installation; then
      post_rke
      aws_cloud_controller_manager
      if check_condition ${config_install_k8s_only}; then
        log_to_sisense_installer "Configured only to install k8s. Exiting..."
        exit 0
      fi
    fi
  fi
  generate_docker_pull_secret
  # Var ${UNIFIED_FILE} is exported and file generated in below function
  generate_overrided_params_wrapper
fi
