#!/usr/bin/env bash

RKE2_VERSION="v1.34.1+rke2r1"
RKE2_DIR_OFFLINE="/tmp/rke2-artiacts"

function first_node() {
  if [[ "${NODE_NAME}" == "${first_node_name}" ]]; then
    return 0
  else
    return 1
  fi
}

function install_and_start_rke2() {
  local mode=agent
  local rke_agent="INSTALL_RKE2_TYPE=agent"
  if first_node; then
    mode=server
    rke_agent=""
  fi

  if check_condition ${offline_installer}; then
    run_command "sudo INSTALL_RKE2_ARTIFACT_PATH=${RKE2_DIR_OFFLINE} sh ${RKE2_DIR_OFFLINE}/install.sh" "Installing RKE2 ${mode} offline"
  else
    # For Amazon Linux 2 below is needed before installing RKE2
    # https://github.com/amazonlinux/container-images/issues/101#issuecomment-1839690977
    if [[ ${OS} == *"Amazon"* && ${VER} == "2" ]]; then
      run_command "sudo amazon-linux-extras enable selinux-ng" "Enabling Amazon Linux extra selinux-ng"
    fi
    run_command "curl -sfL https://get.rke2.io | sudo ${rke_agent} INSTALL_RKE2_VERSION=${RKE2_VERSION} sh -" "Installing RKE2 ${mode}"
  fi

  if [[ -n ${http_proxy} || -n ${https_proxy} ]]; then
    log "Adding proxy details into file /etc/default/rke2-${mode}"
    run_command "echo HTTP_PROXY=${http_proxy} | sudo tee -a /etc/default/rke2-${mode} > /dev/null"
    run_command "echo HTTPS_PROXY=${https_proxy} | sudo tee -a /etc/default/rke2-${mode} > /dev/null"
    run_command "echo NO_PROXY=${no_proxy} | sudo tee -a /etc/default/rke2-${mode} > /dev/null"
  fi

  run_command "sudo systemctl disable nm-cloud-setup.service || true" "Disabling nm-cloud-setup.service"
  run_command "sudo systemctl enable rke2-${mode}.service" "Enabling RKE2 ${mode}"
  run_command "sudo systemctl daemon-reload" "Running sudo systemctl daemon-reload"
  run_command "sudo systemctl restart rke2-${mode}" "Restarting RKE2 ${mode}"
  #journalctl -u rke2-${mode} -f #grep "Tunnel authorizer set Kubelet Port 0.0.0.0:10250"

  if first_node; then
    run_command "sudo chmod 755 /var/lib/rancher/rke2/data/ /var/lib/rancher" "Fixing RKE2 directories permissions"
    local node_status=$(/var/lib/rancher/rke2/bin/kubectl --kubeconfig /etc/rancher/rke2/rke2.yaml get node ${NODE_NAME} --no-headers | awk '{print $2}')
    local try=1
    local limit=30 #2.5 minutes
    local interval=5

    while [[ ${try} -le ${limit} && ${node_status} != "Ready" ]]; do
      log_royal_blue "Waiting for first server node ${NODE_NAME} to be on 'Ready' state... try ${try}/${limit}"
      sleep ${interval}
      node_status=$(/var/lib/rancher/rke2/bin/kubectl --kubeconfig /etc/rancher/rke2/rke2.yaml get node ${NODE_NAME} --no-headers | awk '{print $2}')
      try=$(expr ${try} + 1)
    done

    if [[ ${node_status} == "Ready" ]]; then
      log_green "Server node ${NODE_NAME} is Ready, up and running."
    else
      log_stderr "[ERROR] Server node ${NODE_NAME} has not become Ready after ${limit} tries" 1
    fi
  fi
}

################
##### MAIN #####
################
set_node_name_and_ip
detect_os
install_and_start_rke2
