#!/usr/bin/env bash

WORK_DIR=installer/03_pre_rke_installation
TEMP_CONFIG=${WORK_DIR}/temp_config.yaml
REMOTE_VARS=${WORK_DIR}/remote_vars
REMOTE_SCRIPT=${WORK_DIR}/remote.sh
REMOTE_HOSTS=${WORK_DIR}/hosts
ERROR_DIR=${WORK_DIR}/errors
TEMPLATES_DIR=${WORK_DIR}/templates

source installer/common/functions.sh

function prepare_ssh_keys() {
    if [[ -n ${config_password} ]]; then
        generate_remote_vars "SSH key generation"
        local ssh_name="id_rsa_sisense"
        local ssh_path="${HOME}/.ssh/${ssh_name}"
        local ssh_pub_path="${HOME}/.ssh/${ssh_name}.pub"
        local mode="0600"
        local host=""

        # Generate SSH keypair
        if [[ ! -f ${ssh_path} || ! -f ${ssh_pub_path} ]]; then
            log_to_sisense_installer "Generating ssh key ${ssh_path} ..."
            ssh-keygen -t rsa -b 4096 -f "$ssh_path" -N "" <<<y || handle_exit_status "Generating ssh key"
        fi

        # Set permissions for private key
        run_command "chmod ${mode} ${ssh_path}"

        # Copy SSH key to local and remote hosts
        for host in $(cat ${REMOTE_HOSTS}); do
            sshpass -p "$config_password" ssh-copy-id -f -o StrictHostKeyChecking=no -i "$ssh_pub_path" "$config_linux_user@$host"
            handle_exit_status "copy SSH ID to remote host ${host}"
        done

        # Test SSH connection
        for host in $(cat ${REMOTE_HOSTS}); do
            ssh -o StrictHostKeyChecking=no -i ${ssh_path} "$config_linux_user@$host" "echo success"
            handle_exit_status "test connection to remote host ${host}"
        done

        log_green "SSH key file ${ssh_path} generation done."
    fi
}
