#!/usr/bin/env bash

WORK_DIR=installer/02_sisense_validations
TEMP_CONFIG=${WORK_DIR}/temp_config.yaml
REMOTE_VARS=${WORK_DIR}/remote_vars
REMOTE_SCRIPT=${WORK_DIR}/remote.sh
REMOTE_HOSTS=${WORK_DIR}/hosts
ERROR_DIR=${WORK_DIR}/errors

source installer/common/functions.sh

validate_storage_type_supported() {
    if check_condition "$cluster_mode"; then
        local valid_values=("rook-ceph" "efs" "nfs" "nfs-server" "fsx" "azurefile" "cephfs" "trident" "portworx")

        # Check if the either not configured RWO/RWX/storage_type or if storage_type not in the list of valid values
        if [[ -z "$config_rwx_sc_name" && -z "$config_rwo_sc_name" && -z "$config_storage_type" ]] || 
           [[ -n "$config_storage_type" && ! " ${valid_values[@]} " =~ " $config_storage_type " ]]; then
            log_stderr "ERROR: Unsupported storage type: ${config_storage_type}" 1
        else
            log_to_sisense_installer "Storage type ${config_storage_type} is supported"
        fi
        handle_exit_status "storage type validation"
    fi
}
