{{/*
Expand the name of the chart.
*/}}
{{- define "logging-monitoring.name" -}}
{{- default .Chart.Name .Values.nameOverride | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Create a default fully qualified app name.
We truncate at 63 chars because some Kubernetes name fields are limited to this (by the DNS naming spec).
If release name contains chart name it will be used as a full name.
*/}}
{{- define "logging-monitoring.fullname" -}}
{{- if .Values.fullnameOverride }}
{{- .Values.fullnameOverride | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- $name := default .Chart.Name .Values.nameOverride }}
{{- if contains $name .Release.Name }}
{{- .Release.Name | trunc 63 | trimSuffix "-" }}
{{- else }}
{{- printf "%s-%s" .Release.Name $name | trunc 63 | trimSuffix "-" }}
{{- end }}
{{- end }}
{{- end }}

{{/*
Create chart name and version as used by the chart label.
*/}}
{{- define "logging-monitoring.chart" -}}
{{- printf "%s-%s" .Chart.Name .Chart.Version | replace "+" "_" | trunc 63 | trimSuffix "-" }}
{{- end }}

{{/*
Common labels
*/}}
{{- define "logging-monitoring.labels" -}}
helm.sh/chart: {{ include "logging-monitoring.chart" . }}
{{ include "logging-monitoring.selectorLabels" . }}
{{- if .Chart.AppVersion }}
app.kubernetes.io/version: {{ .Chart.AppVersion | quote }}
{{- end }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
{{- end }}

{{/*
Selector labels
*/}}
{{- define "logging-monitoring.selectorLabels" -}}
app.kubernetes.io/name: {{ include "logging-monitoring.name" . }}
app.kubernetes.io/instance: {{ .Release.Name }}
{{- end }}

{{/*
Create the name of the service account to use
*/}}
{{- define "logging-monitoring.serviceAccountName" -}}
{{- if .Values.serviceAccount.create }}
{{- default (include "logging-monitoring.fullname" .) .Values.serviceAccount.name }}
{{- else }}
{{- default "default" .Values.serviceAccount.name }}
{{- end }}
{{- end }}

{{/*
Below helper functions are for the ansible_cm.yaml
*/}}
{{- define "logging-monitoring.deploymentType" -}}
{{- if .Values.global.cluster_mode.enabled -}}
{{- printf "Cluster" -}}
{{- else -}}
{{- printf "Single" -}}
{{- end -}}
{{- end -}}

{{- define "logging-monitoring.storageType" -}}
{{- $storageType := "hostPath" -}}
{{- $pvc := lookup "v1" "PersistentVolumeClaim" .Release.Namespace "storage" -}}
{{- if $pvc -}}
{{- $storageClass := $pvc.spec.storageClassName -}}
{{- if $storageClass -}}
{{- if contains "fsx" $storageClass -}}
{{- $storageType = "fsx" -}}
{{- else if contains "nfs" $storageClass -}}
{{- $storageType = "nfs" -}}
{{- else if contains "efs" $storageClass -}}
{{- $storageType = "efs" -}}
{{- else if contains "rook-ceph" $storageClass -}}
{{- $storageType = "rook-ceph" -}}
{{- end -}}
{{- end -}}
{{- end -}}
{{- printf "%s" $storageType -}}
{{- end -}}

{{- define "logging-monitoring.kubernetesType" -}}
{{- $kubernetesType := "RKE" -}}
{{- $nodes := lookup "v1" "Node" "" "" -}}
{{- if $nodes -}}
{{- $firstNode := (index $nodes.items 0) -}}
{{- $providerID := $firstNode.spec.providerID -}}
{{- if $providerID -}}
{{- if and (contains "aws://" $providerID) (not (hasKey $firstNode.metadata.annotations "rke.cattle.io/internal-ip")) -}}
{{- $kubernetesType := "EKS" -}}
{{- else if contains "gce://" $providerID -}}
{{- $kubernetesType := "GKE" -}}
{{- else if contains "azure://" $providerID -}}
{{- $kubernetesType := "AKS" -}}
{{- end -}}
{{- else if hasKey $firstNode.metadata.labels "node.openshift.io/os_id" -}}
{{- $kubernetesType := "OpenShift" -}}
{{- end -}}
{{- end -}}
{{- printf "%s" $kubernetesType -}}
{{- end -}}

{{- define "logging-monitoring.kubernetesVersion" -}}
{{- $kubernetesVersion := .Capabilities.KubeVersion.Version -}}
{{- $nodes := lookup "v1" "Node" "" "" -}}
{{- if $nodes -}}
{{- $firstNode := (index $nodes.items 0) -}}
{{- $kubernetesVersion := $firstNode.status.nodeInfo.kubeletVersion -}}
{{- end -}}
{{- printf "%s" $kubernetesVersion -}}
{{- end -}}
